/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.JNLPClassLoader;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyPermission;

public class AppPolicy {
    private String _host = null;
    private File _extensionDir = null;
    private static AppPolicy _instance = null;

    public static AppPolicy getInstance() {
        return _instance;
    }

    public static AppPolicy createInstance(String string) {
        if (_instance == null) {
            _instance = new AppPolicy(string);
        }
        return _instance;
    }

    private AppPolicy(String string) {
        this._host = string;
        this._extensionDir = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public void addPermissions(PermissionCollection permissionCollection, CodeSource codeSource) {
        Trace.println((String)("Permission requested for: " + codeSource.getLocation()), (TraceLevel)TraceLevel.SECURITY);
        JARDesc jARDesc = JNLPClassLoader.getInstance().getJarDescFromFileURL(codeSource.getLocation());
        if (jARDesc == null) {
            return;
        }
        LaunchDesc launchDesc = jARDesc.getParent().getParent();
        int n = launchDesc.getSecurityModel();
        if (n != 0) {
            this.grantUnrestrictedAccess(launchDesc, codeSource);
            if (n == 1) {
                CeilingPolicy.addTrustedPermissions((PermissionCollection)permissionCollection);
            } else {
                this.addJ2EEApplicationClientPermissionsObject(permissionCollection);
            }
        }
        if (!permissionCollection.implies(new AllPermission())) {
            this.addSandboxPermissionsObject(permissionCollection, launchDesc.getLaunchType() == 2);
        }
        if (!launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                PropertyPermission propertyPermission = new PropertyPermission(string, "write");
                CodeSource codeSource2 = Globals.isJavaVersionAtLeast15() ? new CodeSource(jARDesc.getLocation(), codeSource.getCodeSigners()) : new CodeSource(jARDesc.getLocation(), codeSource.getCertificates());
                PermissionCollection permissionCollection2 = Policy.getPolicy().getPermissions(codeSource2);
                if (permissionCollection.implies(propertyPermission) || permissionCollection2.implies(propertyPermission)) {
                    Enumeration<Permission> enumeration2 = permissionCollection2.elements();
                    while (enumeration2.hasMoreElements()) {
                        Permission permission = enumeration2.nextElement();
                        if (!permission.getName().equals(propertyPermission.getName())) continue;
                        permissionCollection.add(permission);
                    }
                    System.setProperty(string, string2);
                    continue;
                }
                Trace.ignoredException((Exception)new AccessControlException("access denied " + propertyPermission, propertyPermission));
            }
            launchDesc.setPropsSet(true);
        }
    }

    private void setUnrestrictedProps(LaunchDesc launchDesc) {
        if (!launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                System.setProperty(string, properties.getProperty(string));
            }
            launchDesc.setPropsSet(true);
        }
    }

    public void grantUnrestrictedAccess(LaunchDesc launchDesc, CodeSource codeSource) {
        String string;
        boolean bl = false;
        switch (launchDesc.getLaunchType()) {
            default: {
                string = "trustdecider.code.type.application";
                break;
            }
            case 2: {
                string = "trustdecider.code.type.applet";
                break;
            }
            case 3: {
                string = "trustdecider.code.type.extension";
                break;
            }
            case 4: {
                string = "trustdecider.code.type.installer";
            }
        }
        try {
            if (Globals.isSecureMode() || TrustDecider.isAllPermissionGranted((CodeSource)codeSource, (AppInfo)launchDesc.getAppInfo())) {
                this.setUnrestrictedProps(launchDesc);
                return;
            }
            Trace.println((String)"We were not granted permission, exiting", (TraceLevel)TraceLevel.SECURITY);
        }
        catch (Exception exception) {
            BadCertificateDialog.show((CodeSource)codeSource, (String)string, (Exception)exception);
        }
        Main.systemExit(-1);
    }

    private void addJ2EEApplicationClientPermissionsObject(PermissionCollection permissionCollection) {
        Trace.println((String)"Creating J2EE-application-client-permisisons object", (TraceLevel)TraceLevel.SECURITY);
        permissionCollection.add(new AWTPermission("accessClipboard"));
        permissionCollection.add(new AWTPermission("accessEventQueue"));
        permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        permissionCollection.add(new RuntimePermission("exitVM"));
        permissionCollection.add(new RuntimePermission("loadLibrary"));
        permissionCollection.add(new RuntimePermission("queuePrintJob"));
        permissionCollection.add(new SocketPermission("*", "connect"));
        permissionCollection.add(new SocketPermission("localhost:1024-", "accept,listen"));
        permissionCollection.add(new FilePermission("*", "read,write"));
        permissionCollection.add(new PropertyPermission("*", "read"));
    }

    private void addSandboxPermissionsObject(PermissionCollection permissionCollection, boolean bl) {
        Trace.println((String)"Add sandbox permissions", (TraceLevel)TraceLevel.SECURITY);
        permissionCollection.add(new PropertyPermission("java.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor.url", "read"));
        permissionCollection.add(new PropertyPermission("java.class.version", "read"));
        permissionCollection.add(new PropertyPermission("os.name", "read"));
        permissionCollection.add(new PropertyPermission("os.arch", "read"));
        permissionCollection.add(new PropertyPermission("os.version", "read"));
        permissionCollection.add(new PropertyPermission("file.separator", "read"));
        permissionCollection.add(new PropertyPermission("path.separator", "read"));
        permissionCollection.add(new PropertyPermission("line.separator", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.name", "read"));
        permissionCollection.add(new PropertyPermission("javawebstart.version", "read"));
        permissionCollection.add(new RuntimePermission("exitVM"));
        permissionCollection.add(new RuntimePermission("stopThread"));
        String string = "Java " + (bl ? "Applet" : "Application") + " Window";
        if (Config.getBooleanProperty((String)"deployment.security.sandbox.awtwarningwindow")) {
            System.setProperty("awt.appletWarning", string);
        } else {
            permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        permissionCollection.add(new SocketPermission("localhost:1024-", "listen"));
        URLUtil.updateSocketHostIPFile((String)this._host);
        permissionCollection.add(new SocketPermission(this._host, "connect, accept"));
        permissionCollection.add(new PropertyPermission("jnlp.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaws.*", "read,write"));
        String[] stringArray = Config.getSecureProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            permissionCollection.add(new PropertyPermission(stringArray[i], "read,write"));
        }
    }
}

