/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

public abstract class DocumentBuilderFactory {
    private static String FACTORY_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static String DEFAULT_FACTORY = "com.caucho.xml.parsers.XmlDocumentBuilderFactory";
    private boolean isCoalescing = false;
    private boolean isExpandEntityReferences = true;
    private boolean isIgnoringComments = false;
    private boolean isIgnoringElementContentWhitespace = false;
    private boolean isNamespaceAware = false;
    private boolean isValidating = false;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public boolean isCoalescing() {
        return this.isCoalescing;
    }

    public void setCoalescing(boolean isCoalescing) {
        this.isCoalescing = isCoalescing;
    }

    public boolean isExpandEntityReferences() {
        return this.isExpandEntityReferences;
    }

    public void setExpandEntityReferences(boolean expand) {
        this.isExpandEntityReferences = expand;
    }

    public boolean isIgnoringComments() {
        return this.isIgnoringComments;
    }

    public void setIgnoringComments(boolean ignore) {
        this.isIgnoringComments = ignore;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.isIgnoringElementContentWhitespace;
    }

    public void setIgnoringElementContentWhitespace(boolean ignore) {
        this.isIgnoringElementContentWhitespace = ignore;
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.isNamespaceAware = namespaceAware;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setValidating(boolean validating) {
        this.isValidating = validating;
    }

    public static DocumentBuilderFactory newInstance() throws FactoryConfigurationError {
        String className = DocumentBuilderFactory.getFactoryClassName();
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                cl = Class.forName(className, false, loader);
            }
        }
        catch (NoSuchMethodError e) {
        }
        catch (ClassNotFoundException e) {
            throw new FactoryConfigurationError(e);
        }
        if (cl == null) {
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new FactoryConfigurationError(e);
            }
        }
        try {
            return (DocumentBuilderFactory)cl.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new FactoryConfigurationError(e);
        }
        catch (InstantiationException e) {
            throw new FactoryConfigurationError(e);
        }
    }

    private static String getFactoryClassName() {
        String className = null;
        try {
            className = System.getProperty(FACTORY_PROPERTY);
            if (className != null) {
                return className;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String serviceName = "META-INF/services/" + FACTORY_PROPERTY;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader != null ? loader.getResourceAsStream(serviceName) : ClassLoader.getSystemResourceAsStream(serviceName);
            InputStreamReader rawReader = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(rawReader);
            className = reader.readLine();
            reader.close();
            is.close();
            if (className != null) {
                className = className.trim();
            }
            if (className != null && !"".equals(className)) {
                return className;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            String javaHome = System.getProperty("java.home");
            String sep = File.separator;
            String propFile = javaHome + sep + "lib" + sep + "jaxp.properties";
            FileInputStream is = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(is);
            ((InputStream)is).close();
            className = props.getProperty(FACTORY_PROPERTY);
            if (className != null) {
                return className;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return DEFAULT_FACTORY;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;
}

