/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DocumentBuilder {
    public abstract DOMImplementation getDOMImplementation();

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public abstract Document newDocument();

    public Document parse(File file) throws SAXException, IOException {
        return this.parse(new InputSource(this.normalizeFilename(file)));
    }

    private String normalizeFilename(File file) {
        String path = file.getAbsolutePath();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("file:");
        if (!path.startsWith("/")) {
            sbuf.append('/');
        }
        int i = 0;
        while (i < path.length()) {
            char ch = path.charAt(i);
            if (ch == '\\') {
                if (i != 0) {
                    sbuf.append('/');
                }
            } else {
                sbuf.append(ch);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public abstract Document parse(InputSource var1) throws SAXException, IOException;

    public Document parse(InputStream stream) throws SAXException, IOException {
        return this.parse(new InputSource(stream));
    }

    public Document parse(InputStream stream, String systemId) throws SAXException, IOException {
        InputSource source = new InputSource(stream);
        source.setSystemId(systemId);
        return this.parse(source);
    }

    public Document parse(String uri) throws SAXException, IOException {
        return this.parse(new InputSource(uri));
    }

    public abstract void setEntityResolver(EntityResolver var1);

    public abstract void setErrorHandler(ErrorHandler var1);
}

